/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.standard.v2_1;

import com.roguewave.chart.core.v2_1.ChartBuilder;
import com.roguewave.chart.core.v2_1.ChartGraphics;
import com.roguewave.chart.core.v2_1.ChartProperties;
import com.roguewave.chart.core.v2_1.ClickCallbackGenerator;
import com.roguewave.chart.core.v2_1.Customizer;
import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.core.v2_1.graphics.Callback;
import com.roguewave.chart.core.v2_1.graphics.ClickablePolygon;
import com.roguewave.chart.core.v2_1.graphics.Line3D;
import com.roguewave.chart.core.v2_1.graphics.Markings3D;
import com.roguewave.chart.core.v2_1.graphics.Markings3DDrawable;
import com.roguewave.chart.core.v2_1.graphics.Point3D;
import com.roguewave.chart.core.v2_1.graphics.Polygon3D;
import com.roguewave.chart.core.v2_1.graphics.Polygon3DDrawable;
import com.roguewave.chart.core.v2_1.graphics.SortTreeInternal;
import com.roguewave.chart.core.v2_1.graphics.SortTreeLeaf;
import com.roguewave.chart.core.v2_1.graphics.StandardColors;
import com.roguewave.chart.core.v2_1.graphics.Transform3D;
import com.roguewave.chart.standard.v2_1.parts.DefaultStyleCustomizer;
import com.roguewave.chart.standard.v2_1.parts.PointerLabel;
import java.awt.Color;
import java.awt.Font;
import java.util.Vector;

public class PieChart
implements ChartBuilder {
    private static final double defaultRadius = 0.5;
    private static final double defaultDepth = 0.15;
    private static final double defaultMarginFactor = 1.75;
    private double fanFactor = 0.08;
    private double overlapCriteria = 24.0;
    private double stagFactor = 0.0;
    private int totalSegments_ = 36;
    private double marginFactor_ = 1.75;
    private boolean axis_;
    private int index_;
    public static final boolean ROW = true;
    public static final boolean COLUMN = false;

    public PieChart(boolean axis, int index) {
        this.axis_ = axis;
        this.index_ = index;
    }

    public PieChart(int row) {
        this(true, row);
    }

    public boolean supports(int viewMode) {
        switch (viewMode) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public ChartGraphics build(ChartProperties properties, DataModel data) {
        int i;
        Color[] colors;
        String[] items;
        int count;
        DefaultStyleCustomizer cust;
        double thickness = properties.getProperty("PartDepth", 0.15);
        double radius = properties.getProperty("PieRadius", 0.5);
        Color labelColor = (Color)properties.getProperty("LabelColor", Color.black);
        Font labelFont = (Font)properties.getProperty("LabelFont", null);
        Boolean labelsShown = (Boolean)properties.getProperty("LabelsShown", new Boolean(true));
        StandardColors stdColors = new StandardColors();
        ClickCallbackGenerator generator = properties.getClickCallbackGenerator();
        ChartGraphics chartGraphics = new ChartGraphics();
        Customizer customizer = properties.get2DStyleCustomizer();
        if (customizer != null) {
            if (this.axis_ && customizer instanceof DefaultStyleCustomizer) {
                cust = new DefaultStyleCustomizer();
                count = data.getColumnCount();
                items = new String[count];
                colors = new Color[count];
                for (i = 0; i < count; ++i) {
                    items[i] = data.getColumnLabel(i);
                    colors[i] = properties.getColor(i, this.index_, stdColors.color(i), 0.0);
                }
                cust.setLegendItems(items, colors);
                chartGraphics.add2DDrawable(cust.getDrawable(properties, data));
            } else {
                chartGraphics.add2DDrawable(customizer.getDrawable(properties, data));
            }
        }
        if ((customizer = properties.get3DStyleCustomizer()) != null) {
            if (this.axis_ && customizer instanceof DefaultStyleCustomizer) {
                cust = new DefaultStyleCustomizer();
                count = data.getColumnCount();
                items = new String[count];
                colors = new Color[count];
                for (i = 0; i < count; ++i) {
                    items[i] = data.getColumnLabel(i);
                    colors[i] = properties.getColor(i, this.index_, stdColors.color(i), 0.0);
                }
                cust.setLegendItems(items, colors);
                chartGraphics.add3DDrawable(cust.getDrawable(properties, data));
            } else {
                chartGraphics.add3DDrawable(customizer.getDrawable(properties, data));
            }
        }
        SortTreeLeaf pie = new SortTreeLeaf();
        SortTreeLeaf labels = null;
        Point3D[] testPoints = new Point3D[3];
        if (labelsShown.booleanValue()) {
            labels = new SortTreeLeaf();
            testPoints[0] = new Point3D(0.0, 0.0, 0.0);
            testPoints[1] = new Point3D(1.0, 0.0, 0.0);
            testPoints[2] = new Point3D(1.0, 0.0, 1.0);
            chartGraphics.setSortTree(new SortTreeInternal(pie, labels, testPoints));
        } else {
            chartGraphics.setSortTree(pie);
        }
        double bottom = -thickness;
        int slices = this.axis_ ? data.getColumnCount() : data.getRowCount();
        Vector<Line3D> topLines = new Vector<Line3D>();
        Vector<Line3D> topLines2D = new Vector<Line3D>();
        Vector<Line3D> bottomLines = new Vector<Line3D>();
        Transform3D rot82d = Transform3D.rotateX(-90.0);
        StandardColors colors2 = new StandardColors();
        double[] arcs = this.calculateArcs(data, slices);
        double arcPerSegment = Math.PI * 2 / (double)this.totalSegments_;
        double startArc = 0.0;
        Polygon3D top = null;
        Polygon3D bot = null;
        Markings3DDrawable[] edgeMarkings = new Markings3DDrawable[slices];
        double lastMidArc = 0.0;
        boolean groupFlag = false;
        int group = 0;
        int[] howMany = new int[slices];
        int[] belong = new int[slices];
        double[] fan = new double[slices];
        int finalGroup = 0;
        this.overlapCriteria = Math.abs(this.overlapCriteria);
        for (int tooMany = 0; tooMany < slices && (double)slices > this.overlapCriteria; ++tooMany) {
            this.fanFactor *= 0.8;
            this.overlapCriteria *= 1.3;
        }
        double separation = Math.PI * 2 / this.overlapCriteria;
        for (int s = 0; s < slices; ++s) {
            double midArc = startArc + arcs[s] / 2.0;
            if (s > 0 && Math.IEEEremainder(midArc - lastMidArc + Math.PI * 2, Math.PI * 2) < separation || s < slices - 1 && Math.IEEEremainder(startArc + arcs[s] + arcs[s + 1] / 2.0 - midArc + Math.PI * 2, Math.PI * 2) < separation) {
                belong[s] = group;
                int n = group;
                howMany[n] = howMany[n] + 1;
                finalGroup = group;
                groupFlag = true;
            } else {
                if (groupFlag) {
                    // empty if block
                }
                belong[s] = ++group;
                int n = group;
                howMany[n] = howMany[n] + 1;
                finalGroup = group++;
                groupFlag = false;
            }
            lastMidArc = midArc;
            startArc += arcs[s];
        }
        double finalMidArc = lastMidArc;
        double firstMidArc = arcs[0] / 2.0;
        double[] lineDirections = new double[slices];
        double stagger = 0.0;
        double fanAdjust = 0.8 / this.overlapCriteria;
        if (Math.IEEEremainder(firstMidArc - finalMidArc + Math.PI * 4, Math.PI * 2) < separation) {
            int n = finalGroup;
            howMany[n] = howMany[n] + howMany[0];
            for (group = 1; group <= finalGroup; ++group) {
                lineDirections[group] = (double)(-howMany[group]) / 2.0 + 0.5;
                fan[group] = this.fanFactor * (1.0 - (double)howMany[group] * fanAdjust);
            }
            lineDirections[0] = lineDirections[finalGroup] + (double)howMany[finalGroup] - (double)howMany[0];
            fan[0] = fan[finalGroup];
        } else {
            for (group = 0; group <= finalGroup; ++group) {
                lineDirections[group] = (double)(-howMany[group]) / 2.0 + 0.5;
                fan[group] = this.fanFactor * (1.0 - (double)howMany[group] * fanAdjust);
            }
        }
        for (int s = 0; s < slices; ++s) {
            PointerLabel label = null;
            if (labelsShown.booleanValue()) {
                double midArc = startArc + arcs[s] / 2.0;
                double innerRadius = radius * 0.75;
                double outerRadius = radius * 1.3;
                double outArc = midArc + fan[belong[s]] * lineDirections[belong[s]];
                double stagRad = outerRadius + stagger * this.stagFactor;
                if ((stagger += 1.0) == 2.0) {
                    stagger = 0.0;
                }
                Point3D inPoint = new Point3D(innerRadius * Math.cos(midArc), 0.0, innerRadius * Math.sin(midArc));
                Point3D outPoint = new Point3D(stagRad * Math.cos(outArc), 0.0, stagRad * Math.sin(outArc));
                int n = belong[s];
                lineDirections[n] = lineDirections[n] + 1.0;
                String labelString = this.axis_ ? data.getColumnLabel(s) : data.getRowLabel(s);
                label = new PointerLabel(labelString, inPoint, outPoint, labelColor, labelColor, labelFont);
                labels.addDrawable(label);
            }
            if (arcs[s] <= 0.0) {
                edgeMarkings[s] = null;
            } else {
                Color color = properties.getColor(s, 0, colors2.color(s), 0.0);
                int segments = (int)Math.ceil(arcs[s] / arcPerSegment);
                double sliceArcSize = 0.0;
                if (segments != 0) {
                    sliceArcSize = arcs[s] / (double)segments;
                }
                top = new Polygon3D(segments + 2, color);
                top.setOutlines(false);
                Point3D[] bottomPoints = new Point3D[segments + 2];
                top.addPoint(new Point3D(0.0, 0.0, 0.0));
                bottomPoints[segments + 1] = new Point3D(0.0, bottom, 0.0);
                double endArc = startArc + arcs[s];
                double xlast = 0.0;
                double zlast = 0.0;
                Polygon3D[] edges = new Polygon3D[segments];
                for (int segment = 0; segment <= segments; ++segment) {
                    double x = radius * Math.cos(endArc - (double)segment * sliceArcSize);
                    double z = radius * Math.sin(endArc - (double)segment * sliceArcSize);
                    top.addPoint(new Point3D(x, 0.0, z));
                    bottomPoints[segments - segment] = new Point3D(x, bottom, z);
                    if (segment == 0) {
                        Line3D line = new Line3D(new Point3D(0.0, 0.0, 0.0), new Point3D(x, 0.0, z));
                        topLines.addElement(line);
                        topLines2D.addElement(line.transform(rot82d));
                        bottomLines.addElement(new Line3D(new Point3D(0.0, bottom, 0.0), new Point3D(x, bottom, z)));
                    } else {
                        Polygon3D edge = new Polygon3D(4, color.darker());
                        edge.setOutlines(false);
                        edge.addPoint(new Point3D(xlast, 0.0, zlast));
                        edge.addPoint(new Point3D(xlast, bottom, zlast));
                        edge.addPoint(new Point3D(x, bottom, z));
                        edge.addPoint(new Point3D(x, 0.0, z));
                        edges[segment - 1] = edge;
                        if (segment == segments) {
                            Markings3DDrawable edgeLine;
                            Vector<Line3D> lines = new Vector<Line3D>(1);
                            lines.addElement(new Line3D(new Point3D(x, 0.0, z), new Point3D(x, bottom, z)));
                            edgeMarkings[s] = edgeLine = new Markings3DDrawable(new Markings3D(edge, lines), Color.black);
                        }
                    }
                    xlast = x;
                    zlast = z;
                }
                Callback callback = null;
                if (generator == null) {
                    pie.addDrawable(new Polygon3DDrawable(top));
                } else {
                    int column;
                    int row;
                    if (this.axis_) {
                        row = this.index_;
                        column = s;
                    } else {
                        row = s;
                        column = this.index_;
                    }
                    int[] rowArr = new int[]{row};
                    int[] colArr = new int[]{column};
                    callback = generator.generateCallback(data, rowArr, colArr);
                    pie.addClickable(new ClickablePolygon(top, callback));
                }
                chartGraphics.add2DDrawable(new Polygon3DDrawable(top.transform(rot82d)));
                bot = new Polygon3D(segments + 2, color);
                bot.setOutlines(false);
                for (int i2 = 0; i2 < bottomPoints.length; ++i2) {
                    bot.addPoint(bottomPoints[i2]);
                }
                pie.addDrawable(new Polygon3DDrawable(bot));
                startArc += arcs[s];
                for (int i3 = 0; i3 < edges.length; ++i3) {
                    if (generator == null) {
                        pie.addDrawable(new Polygon3DDrawable(edges[i3]));
                        continue;
                    }
                    pie.addClickable(new ClickablePolygon(edges[i3], callback));
                }
            }
            if (label == null) continue;
            chartGraphics.add2DDrawable(label.transform(rot82d));
        }
        if (slices > 1) {
            Markings3D markings = new Markings3D(top, topLines);
            Markings3DDrawable dMarkings = new Markings3DDrawable(markings, Color.black);
            pie.addDrawable(dMarkings);
            markings = new Markings3D(top, topLines2D);
            dMarkings = new Markings3DDrawable(markings, Color.black);
            chartGraphics.add2DDrawable(dMarkings);
            markings = new Markings3D(bot, bottomLines);
            dMarkings = new Markings3DDrawable(markings, Color.black);
            pie.addDrawable(dMarkings);
            for (int i4 = 0; i4 < slices; ++i4) {
                if (edgeMarkings[i4] == null) continue;
                pie.addDrawable(edgeMarkings[i4]);
            }
        }
        double marginFactor = properties.getProperty("marginFactor", this.marginFactor_);
        radius = labelsShown.booleanValue() ? (radius *= this.marginFactor_) : (radius *= 1.05);
        int samples = 16;
        Point3D[] bounds = new Point3D[2 * samples];
        double arc = Math.PI * 2 / (double)samples;
        for (int i5 = 0; i5 < samples; ++i5) {
            double x = radius * Math.cos((double)i5 * arc);
            double z = radius * Math.sin((double)i5 * arc);
            bounds[i5 * 2] = new Point3D(x, 0.0, z);
            bounds[i5 * 2 + 1] = new Point3D(x, bottom, z);
        }
        chartGraphics.setBounds3D(bounds);
        Point3D[] bounds2D = new Point3D[samples];
        for (int i6 = 0; i6 < samples; ++i6) {
            bounds2D[i6] = rot82d.transform(bounds[i6 * 2]);
        }
        chartGraphics.setBounds2D(bounds2D);
        return chartGraphics;
    }

    public boolean getAxis() {
        return this.axis_;
    }

    public void setAxis(boolean axis) {
        if (this.axis_ != axis) {
            this.axis_ = axis;
            this.index_ = 0;
        }
    }

    public int getIndex() {
        return this.index_;
    }

    public void setIndex(int index) {
        this.index_ = index;
    }

    private double[] calculateArcs(DataModel data, int slices) {
        double total = 0.0;
        int row = this.axis_ ? this.index_ : 0;
        int column = !this.axis_ ? this.index_ : 0;
        int rowInc = !this.axis_ ? 1 : 0;
        int columnInc = this.axis_ ? 1 : 0;
        for (int i = 0; i < slices; ++i) {
            double value = data.getValue(row, column);
            if (value < 0.0) {
                throw new IllegalArgumentException("values < 0 are illegal for pie charts");
            }
            total += value;
            row += rowInc;
            column += columnInc;
        }
        if (this.axis_) {
            column = 0;
        } else {
            row = 0;
        }
        if (total == 0.0) {
            throw new IllegalArgumentException("data sets with no non-zero values are illegal for pie charts");
        }
        double[] arcs = new double[slices];
        for (int i = 0; i < slices; ++i) {
            arcs[i] = data.getValue(row, column) * 2.0 * Math.PI / total;
            row += rowInc;
            column += columnInc;
        }
        return arcs;
    }

    public void setFanFactor(double x) {
        this.fanFactor = x;
    }

    public void setStagFactor(double x) {
        this.stagFactor = x;
    }

    public void setOverlapCriteria(double x) {
        this.overlapCriteria = x;
    }

    public double getFanFactor() {
        return this.fanFactor;
    }

    public double getStagFactor() {
        return this.stagFactor;
    }

    public double getOverlapCriteria() {
        return this.overlapCriteria;
    }

    public int getTotalSegments() {
        return this.totalSegments_;
    }

    public void setTotalSegments(int segments) {
        this.totalSegments_ = segments;
    }

    public double getMarginFactor() {
        return this.marginFactor_;
    }

    public void setMarginFactor(double factor) {
        this.marginFactor_ = factor;
    }
}

